//
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.

//
// CREATED BY:
// David Barbour, June 2001
//
// DESCRIPTION:

// AcMapOrclBlock.cpp : Initialization functions

#include "StdAfx.h"
#include "StdArx.h"
#include "resource.h"
#include <vector>
#include "AcMapOAddCmdSaveBlocks.h"	// for AcMapOAddCmdSaveBlocks
#include "AcMapOAddCmdRestoreBlocks.h"	// for AcMapOAddCmdRestoreBlocks


HINSTANCE _hdllInstance =NULL ;

// This command registers an ARX command.
void AddCommand(
	const char* cmdGroup,
	const char* cmdInt,
	const char* cmdLoc,
	const int cmdFlags,
	const AcRxFunctionPtr cmdProc,
	const int idLocal = -1);


// NOTE: DO NOT edit the following lines.
//{{AFX_ARX_MSG
void InitApplication();
void UnloadApplication();
//}}AFX_ARX_MSG

// NOTE: DO NOT edit the following lines.
//{{AFX_ARX_ADDIN_FUNCS
//}}AFX_ARX_ADDIN_FUNCS


////////////////////////////////////////////////////////////////////////////
//
// Define the sole extension module object.
//AC_IMPLEMENT_EXTENSION_MODULE(AcMapOrclUIDLL);

// Now you can use the CAcModuleResourceOverride class in
// your application to switch to the correct resource instance.
// Please see the ObjectARX Documentation for more details
//static Amap::CResourceModule s_resources;
/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point
extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
        _hdllInstance = hInstance;
		// Extension DLL one time initialization
	}
	return TRUE;    // ok
}

//******************************************************************************************
//Name of module with resources
const char * const kpResourceFile = /*NOXLATE*/"AcMapOrclBlock.arx";


//******************************************************************************************
// retruns the handle of the resource module
HINSTANCE ResourceModule()
{
	return _hdllInstance;
}

//******************************************************************************************
//Set up our list of registered commands, which RegisterCommands() and
//UnregisterCommands() will maintain.  We need to declare the list and
//declare a convenient macro for inserting items.

//******************************************************************************************
//This function registers all AutoCAD Map commands that use the
//new command framework.  Whenever a new command is added, a single
//line needs to be added to the map command list table below.
//
//This function should be called exactly once, from the module's
//acrxEntryPoint, at application startup time.

void RegisterCommands()
{
	try
	{
		//MAPO_COMMAND_LIST
		//For each command to be added via CAcMapCommand,
		//add an entry here.  Note that this design requires
		//that the command class' constructor includes the
		//necessary call to CAcMapCmdManager::AddCommand()
		//for proper registration.
		AddCommand(
			"ACMAPSAMPLE",
			"SAVEBLOCKTOORACLE",
			"SAVEBLOCKTOORACLE",
			ACRX_CMD_TRANSPARENT | ACRX_CMD_MODAL,
			AcMapOAddCmdSaveBlock);
		AddCommand(
			"ACMAPSAMPLE",
			"LOADBLOCKSFROMORACLE",
			"LOADBLOCKSFROMORACLE",
			ACRX_CMD_TRANSPARENT | ACRX_CMD_MODAL,
			AcMapOAddCmdRestoreBlock);
		AddCommand(
			"ACMAPSAMPLE",
			"STOPSAVEBLOCKTOORACLE",
			"STOPSAVEBLOCKTOORACLE",
			ACRX_CMD_TRANSPARENT | ACRX_CMD_MODAL,
			AcMapOAddCmdStopSaveBlock);
	}
	catch (const std::bad_alloc&)
	{
		//out of memory
		return;
	}
}


/////////////////////////////////////////////////////////////////////////////
// ObjectARX EntryPoint
extern "C" AcRx::AppRetCode 
acrxEntryPoint(AcRx::AppMsgCode msg, void* pkt)
{
	switch (msg) {
	case AcRx::kInitAppMsg:
		// Comment out the following line if your
		// application should be locked into memory
		acrxDynamicLinker->unlockApplication(pkt);
		acrxDynamicLinker->registerAppMDIAware(pkt);
		InitApplication();
		break;
	case AcRx::kUnloadAppMsg:
		UnloadApplication();
		break;
	}
	return AcRx::kRetOK;
}

#ifndef NDEBUG
#endif

// Init this application. Register your
// commands, reactors...
void InitApplication()
{
	// NOTE: DO NOT edit the following lines.
	//{{AFX_ARX_INIT
#ifndef NDEBUG
#endif
	//}}AFX_ARX_INIT

	// TODO: add your initialization functions
	RegisterCommands();

	// Load AcMapOrcl module
	//
}

// Unload this application. Unregister all objects
// registered in InitApplication.
void UnloadApplication()
{
	// NOTE: DO NOT edit the following lines.
	//{{AFX_ARX_EXIT
#ifndef NDEBUG
	acedRegCmds->removeGroup("ACMAPSAMPLE");
#endif
	//}}AFX_ARX_EXIT

	// TODO: clean up your application
}



// This functions registers an ARX command.
// It can be used to read the localized command name
// from a string table stored in the resources.
void AddCommand(const char* cmdGroup, const char* cmdInt, const char* cmdLoc,
				const int cmdFlags, const AcRxFunctionPtr cmdProc, const int idLocal)
{
	char cmdLocRes[65];

	// If idLocal is not -1, it's treated as an ID for
	// a string stored in the resources.
	if (idLocal != -1) {

		// Load strings from the string table and register the command.
		::LoadString(_hdllInstance, idLocal, cmdLocRes, 64);
		acedRegCmds->addCommand(cmdGroup, cmdInt, cmdLocRes, cmdFlags, cmdProc);

	} else
		// idLocal is -1, so the 'hard coded'
		// localized function name is used.
		acedRegCmds->addCommand(cmdGroup, cmdInt, cmdLoc, cmdFlags, cmdProc);
}



//eof